/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration.org.springframework.cloud.service.keyval;

import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.MapServiceConnectionConfigurer;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.MapServiceConnectorConfig;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.PooledServiceConnectorConfig;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.ServiceConnectorConfigurer;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.Util;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.keyval.RedisConnectionFactoryConfig;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;

public class RedisLettuceClientConfigurer
implements ServiceConnectorConfigurer<LettuceClientConfiguration.LettuceClientConfigurationBuilder, RedisConnectionFactoryConfig> {
    private MapServiceConnectionConfigurer<LettuceClientConfiguration.LettuceClientConfigurationBuilder, MapServiceConnectorConfig> mapClientConfigurer = new MapServiceConnectionConfigurer();

    @Override
    public LettuceClientConfiguration.LettuceClientConfigurationBuilder configure(LettuceClientConfiguration.LettuceClientConfigurationBuilder clientConfiguration, RedisConnectionFactoryConfig config) {
        if (config != null) {
            this.configurePool(clientConfiguration, config);
            this.configureClient(clientConfiguration, config);
        }
        return clientConfiguration;
    }

    @Override
    public LettuceClientConfiguration.LettuceClientConfigurationBuilder configure(LettuceClientConfiguration.LettuceClientConfigurationBuilder clientConfiguration, PooledServiceConnectorConfig config) {
        if (config != null) {
            this.configurePool(clientConfiguration, config);
        }
        return clientConfiguration;
    }

    private void configurePool(LettuceClientConfiguration.LettuceClientConfigurationBuilder clientConfiguration, PooledServiceConnectorConfig config) {
        if (config.getPoolConfig() != null) {
            GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
            BeanWrapperImpl target = new BeanWrapperImpl((Object)poolConfig);
            BeanWrapperImpl source = new BeanWrapperImpl((Object)config.getPoolConfig());
            Util.setCorrespondingProperties((BeanWrapper)target, (BeanWrapper)source);
            ((LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder)clientConfiguration).poolConfig(poolConfig);
        }
    }

    private void configureClient(LettuceClientConfiguration.LettuceClientConfigurationBuilder clientConfiguration, RedisConnectionFactoryConfig config) {
        if (config.getConnectionProperties() != null) {
            this.mapClientConfigurer.configure(clientConfiguration, config.getConnectionProperties());
        }
    }
}

