/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration.org.springframework.cloud.service.keyval;

import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.MapServiceConnectionConfigurer;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.MapServiceConnectorConfig;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.PooledServiceConnectorConfig;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.ServiceConnectorConfigurer;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.Util;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.keyval.RedisConnectionFactoryConfig;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import redis.clients.jedis.JedisPoolConfig;

public class SpringData1RedisConnectionFactoryConfigurer
implements ServiceConnectorConfigurer<JedisConnectionFactory, RedisConnectionFactoryConfig> {
    private MapServiceConnectionConfigurer<JedisConnectionFactory, MapServiceConnectorConfig> mapServiceConnectionConfigurer = new MapServiceConnectionConfigurer();

    @Override
    public JedisConnectionFactory configure(JedisConnectionFactory connectionFactory, RedisConnectionFactoryConfig config) {
        if (config != null) {
            this.configurePool(connectionFactory, config);
            this.configureConnection(connectionFactory, config);
        }
        return connectionFactory;
    }

    @Override
    public JedisConnectionFactory configure(JedisConnectionFactory connectionFactory, PooledServiceConnectorConfig config) {
        if (config != null) {
            this.configurePool(connectionFactory, config);
        }
        return connectionFactory;
    }

    private void configurePool(JedisConnectionFactory connectionFactory, PooledServiceConnectorConfig config) {
        if (config.getPoolConfig() != null) {
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            BeanWrapperImpl target = new BeanWrapperImpl((Object)poolConfig);
            BeanWrapperImpl source = new BeanWrapperImpl((Object)config.getPoolConfig());
            Util.setCorrespondingProperties((BeanWrapper)target, (BeanWrapper)source);
            connectionFactory.setPoolConfig(poolConfig);
        }
    }

    private void configureConnection(JedisConnectionFactory connectionFactory, RedisConnectionFactoryConfig config) {
        if (config.getConnectionProperties() != null) {
            this.mapServiceConnectionConfigurer.configure(connectionFactory, config.getConnectionProperties());
        }
    }
}

