/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration.org.springframework.cloud.service.relational;

import javax.sql.DataSource;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.MapServiceConnectionConfigurer;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.MapServiceConnectorConfig;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.PooledServiceConnectorConfig;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.PooledServiceConnectorConfigurer;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.Util;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.relational.DataSourceConfig;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;

public class DataSourceConfigurer
extends PooledServiceConnectorConfigurer<DataSource, DataSourceConfig> {
    private MapServiceConnectionConfigurer<DataSource, MapServiceConnectorConfig> mapServiceConnectionConfigurer = new MapServiceConnectionConfigurer();

    @Override
    public DataSource configure(DataSource dataSource, DataSourceConfig config) {
        if (config == null) {
            config = new DataSourceConfig(new PooledServiceConnectorConfig.PoolConfig(4, 30000), null);
        }
        this.configureConnection(dataSource, config);
        this.configureConnectionProperties(dataSource, config);
        return super.configure(dataSource, config);
    }

    private void configureConnection(DataSource dataSource, DataSourceConfig config) {
        if (config.getConnectionConfiguration() != null) {
            BeanWrapperImpl target = new BeanWrapperImpl((Object)dataSource);
            BeanWrapperImpl connectionSource = new BeanWrapperImpl((Object)config.getConnectionConfiguration());
            Util.setCorrespondingProperties((BeanWrapper)target, (BeanWrapper)connectionSource);
        }
    }

    private void configureConnectionProperties(DataSource dataSource, DataSourceConfig config) {
        if (config.getConnectionProperties() != null) {
            this.mapServiceConnectionConfigurer.configure(dataSource, config.getConnectionProperties());
        }
    }
}

