/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration.org.springframework.cloud.service.relational;

import com.zaxxer.hikari.HikariDataSource;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.ServiceConnectorConfig;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.Util;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.common.RelationalServiceInfo;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.relational.DataSourceConfig;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.relational.DataSourceConfigurer;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.relational.PooledDataSourceCreator;
import org.springframework.beans.BeanWrapperImpl;

public class HikariCpPooledDataSourceCreator<SI extends RelationalServiceInfo>
implements PooledDataSourceCreator<SI> {
    protected static Logger logger = Logger.getLogger(PooledDataSourceCreator.class.getName());
    public static final String HIKARI_DATASOURCE = "com.zaxxer.hikari.HikariDataSource";
    private DataSourceConfigurer configurer = new DataSourceConfigurer();

    protected void setBasicDataSourceProperties(DataSource basicDataSource, RelationalServiceInfo serviceInfo, ServiceConnectorConfig serviceConnectorConfig, String driverClassName, String validationQuery) {
        BeanWrapperImpl target = new BeanWrapperImpl((Object)basicDataSource);
        target.setPropertyValue("driverClassName", (Object)driverClassName);
        target.setPropertyValue("jdbcUrl", (Object)serviceInfo.getJdbcUrl());
        if (validationQuery != null) {
            target.setPropertyValue("connectionTestQuery", (Object)validationQuery);
        }
        this.configurer.configure(basicDataSource, (DataSourceConfig)serviceConnectorConfig);
    }

    @Override
    public DataSource create(RelationalServiceInfo serviceInfo, ServiceConnectorConfig serviceConnectorConfig, String driverClassName, String validationQuery) {
        if (Util.hasClass(HIKARI_DATASOURCE)) {
            logger.info("Found HikariCP on the classpath. Using it for DataSource connection pooling.");
            HikariDataSource ds = new HikariDataSource();
            this.setBasicDataSourceProperties((DataSource)ds, serviceInfo, serviceConnectorConfig, driverClassName, validationQuery);
            return ds;
        }
        return null;
    }
}

