/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration.org.springframework.cloud.service.relational;

import javax.sql.DataSource;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.ServiceConnectorConfig;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.ServiceConnectorCreationException;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.Util;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.common.RelationalServiceInfo;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.relational.DbcpLikePooledDataSourceCreator;

public class TomcatDbcpPooledDataSourceCreator<SI extends RelationalServiceInfo>
extends DbcpLikePooledDataSourceCreator<SI> {
    public static final String TOMCAT_7_DBCP = "org.apache.tomcat.dbcp.dbcp.BasicDataSource";
    public static final String TOMCAT_8_DBCP = "org.apache.tomcat.dbcp.dbcp2.BasicDataSource";

    @Override
    public DataSource create(RelationalServiceInfo serviceInfo, ServiceConnectorConfig serviceConnectorConfig, String driverClassName, String validationQuery) {
        if (Util.hasClass(TOMCAT_7_DBCP)) {
            logger.info("Found Tomcat 7 DBCP connection pool on the classpath. Using it for DataSource connection pooling.");
            return this.createDataSource(TOMCAT_7_DBCP, serviceInfo, serviceConnectorConfig, driverClassName, validationQuery);
        }
        if (Util.hasClass(TOMCAT_8_DBCP)) {
            logger.info("Found Tomcat 8 DBCP connection pool on the classpath. Using it for DataSource connection pooling.");
            return this.createDataSource(TOMCAT_8_DBCP, serviceInfo, serviceConnectorConfig, driverClassName, validationQuery);
        }
        return null;
    }

    private DataSource createDataSource(String className, RelationalServiceInfo serviceInfo, ServiceConnectorConfig serviceConnectorConfig, String driverClassName, String validationQuery) {
        try {
            DataSource dataSource = (DataSource)Class.forName(className).newInstance();
            this.setBasicDataSourceProperties(dataSource, serviceInfo, serviceConnectorConfig, driverClassName, validationQuery);
            return dataSource;
        }
        catch (Throwable e) {
            throw new ServiceConnectorCreationException("Error instantiating Tomcat DBCP connection pool", e);
        }
    }
}

