/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration.org.springframework.cloud.util;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServiceLoaderWithExceptionControl<T>
implements Iterable<T> {
    private Iterable<T> underlying;
    private static Logger logger = Logger.getLogger(ServiceLoaderWithExceptionControl.class.getName());

    public static <T> Iterable<T> load(Class<T> serviceType) {
        ServiceLoader<T> loader = ServiceLoader.load(serviceType);
        return new ServiceLoaderWithExceptionControl<T>(loader);
    }

    private ServiceLoaderWithExceptionControl(Iterable<T> underlying) {
        this.underlying = underlying;
    }

    @Override
    public Iterator<T> iterator() {
        return new ServiceLoaderIterator(this.underlying.iterator());
    }

    private class ServiceLoaderIterator
    implements Iterator<T> {
        private Iterator<T> underlying;

        public ServiceLoaderIterator(Iterator<T> underlying) {
            this.underlying = underlying;
        }

        @Override
        public boolean hasNext() {
            return this.underlying.hasNext();
        }

        @Override
        public T next() {
            try {
                return this.underlying.next();
            }
            catch (ServiceConfigurationError e) {
                logger.log(Level.CONFIG, "Failed to load " + e);
                if (this.hasNext()) {
                    return this.next();
                }
                return null;
            }
        }

        @Override
        public void remove() {
            this.underlying.remove();
        }
    }
}

