/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.certificate;

import java.nio.file.Path;
import java.nio.file.Paths;

final class Arguments {
    private final Path containerSource;
    private final Path destination;
    private final String destinationPassword;
    private final Path jreSource;
    private final String jreSourcePassword;

    private Arguments(Path containerSource, Path destination, String destinationPassword, Path jreSource, String jreSourcePassword) {
        this.containerSource = containerSource;
        this.destination = destination;
        this.destinationPassword = destinationPassword;
        this.jreSource = jreSource;
        this.jreSourcePassword = jreSourcePassword;
    }

    static Arguments parse(String[] args) {
        String containerSource = null;
        String destination = null;
        String destinationPassword = null;
        String jreSource = null;
        String jreSourcePassword = null;
        int index = 0;
        while (index < args.length) {
            switch (args[index++]) {
                case "--container-source": {
                    containerSource = args[index++];
                    break;
                }
                case "--destination": {
                    destination = args[index++];
                    break;
                }
                case "--destination-password": {
                    destinationPassword = args[index++];
                    break;
                }
                case "--jre-source": {
                    jreSource = args[index++];
                    break;
                }
                case "--jre-source-password": {
                    jreSourcePassword = args[index++];
                    break;
                }
            }
        }
        if (containerSource == null) {
            throw new IllegalArgumentException("Must specify --container-source");
        }
        if (destination == null) {
            throw new IllegalArgumentException("Must specify --destination");
        }
        if (destinationPassword == null) {
            throw new IllegalArgumentException("Must specify --destination-password");
        }
        if (jreSource == null) {
            throw new IllegalArgumentException("Must specify --jre-source");
        }
        if (jreSourcePassword == null) {
            throw new IllegalArgumentException("Must specify --jre-source-password");
        }
        return new Arguments(Paths.get(containerSource, new String[0]), Paths.get(destination, new String[0]), destinationPassword, Paths.get(jreSource, new String[0]), jreSourcePassword);
    }

    Path getContainerSource() {
        return this.containerSource;
    }

    Path getDestination() {
        return this.destination;
    }

    String getDestinationPassword() {
        return this.destinationPassword;
    }

    Path getJreSource() {
        return this.jreSource;
    }

    String getJreSourcePassword() {
        return this.jreSourcePassword;
    }
}

