/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.certificate;

import java.util.ArrayList;
import java.util.List;

final class CertificateBuilder {
    private static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    private final List<String> certificates = new ArrayList<String>();
    private List<String> current;

    private CertificateBuilder() {
    }

    static CertificateBuilder accumulate(CertificateBuilder builder, String s) {
        if (BEGIN_CERTIFICATE.equals(s)) {
            builder.start();
        }
        builder.add(s);
        if (END_CERTIFICATE.equals(s)) {
            builder.end();
        }
        return builder;
    }

    static CertificateBuilder combine(CertificateBuilder left, CertificateBuilder right) {
        left.pemEncodedCertificates().addAll(right.certificates);
        return left;
    }

    static CertificateBuilder identity() {
        return new CertificateBuilder();
    }

    List<String> pemEncodedCertificates() {
        return this.certificates;
    }

    private void add(String s) {
        if (this.current == null) {
            return;
        }
        this.current.add(s);
    }

    private void end() {
        if (this.current == null) {
            return;
        }
        this.certificates.add(this.join(this.current, "\n"));
        this.current = null;
    }

    private String join(List<String> source, String delimiter) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String s : source) {
            if (i > 0) {
                sb.append(delimiter);
            }
            sb.append(s);
            ++i;
        }
        return sb.toString();
    }

    private void start() {
        this.current = new ArrayList<String>();
    }
}

