/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.certificate;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.concurrent.atomic.AtomicInteger;

final class KeyStoreBuilder {
    private static final AtomicInteger counter = new AtomicInteger();

    KeyStoreBuilder() {
    }

    static KeyStore accumulate(KeyStore keyStore, Certificate certificate) throws KeyStoreException {
        keyStore.setCertificateEntry(KeyStoreBuilder.getAlias(), certificate);
        return keyStore;
    }

    static KeyStore identity() throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null);
        return keyStore;
    }

    private static String getAlias() {
        return String.valueOf(counter.getAndIncrement());
    }
}

