/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.certificate;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

final class X509CertificateBuilder {
    private static final CertificateFactory CERTIFICATE_FACTORY;

    X509CertificateBuilder() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static X509Certificate toCertificate(String s) {
        try (ByteArrayInputStream in = new ByteArrayInputStream(s.getBytes(Charset.forName("UTF-8")));){
            X509Certificate x509Certificate = (X509Certificate)CERTIFICATE_FACTORY.generateCertificate(in);
            return x509Certificate;
        }
        catch (IOException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            CERTIFICATE_FACTORY = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
    }
}

