/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.security;

import java.lang.reflect.UndeclaredThrowableException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509ExtendedTrustManager;
import org.cloudfoundry.security.DelegatingX509ExtendedTrustManager;
import org.cloudfoundry.security.FileWatchingX509ExtendedTrustManager;

abstract class CloudFoundryContainerTrustManagerFactory
extends TrustManagerFactorySpi {
    private static final String CA_CERTIFICATES_PROPERTY = "CF_CA_CERTS";
    private static final Path DEFAULT_CA_CERTIFICATES = Paths.get("/etc/ssl/certs/ca-certificates.crt", new String[0]);
    private static final Object MONITOR = new Object();
    private static FileWatchingX509ExtendedTrustManager CACHED_CONTAINER_TRUST_MANAGER;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final String algorithm;
    private final Path certificates;
    private final TrustManagerFactory systemTrustManagerFactory;
    private X509ExtendedTrustManager cachedSystemTrustManager;

    private CloudFoundryContainerTrustManagerFactory(String algorithm, Path certificates) {
        this.algorithm = algorithm;
        this.certificates = certificates;
        this.systemTrustManagerFactory = this.getTrustManagerFactory();
        this.logger.fine(String.format("Algorithm: %s", algorithm));
        this.logger.fine(String.format("Certificates: %s", certificates));
    }

    @Override
    protected final TrustManager[] engineGetTrustManagers() {
        FileWatchingX509ExtendedTrustManager containerTrustManager;
        ArrayList<X509ExtendedTrustManager> delegates = new ArrayList<X509ExtendedTrustManager>();
        X509ExtendedTrustManager systemTrustManager = this.getSystemTrustManager();
        if (systemTrustManager != null) {
            delegates.add(systemTrustManager);
        }
        if ((containerTrustManager = this.getContainerTrustManager()) != null) {
            delegates.add(containerTrustManager);
        }
        return new TrustManager[]{new DelegatingX509ExtendedTrustManager(delegates)};
    }

    @Override
    protected final void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        this.systemTrustManagerFactory.init(managerFactoryParameters);
        this.invalidateSystemTrustManager();
    }

    @Override
    protected final void engineInit(KeyStore keyStore) throws KeyStoreException {
        this.systemTrustManagerFactory.init(keyStore);
        this.invalidateSystemTrustManager();
    }

    private static Path getCertificatesLocation() {
        String candidate = System.getenv(CA_CERTIFICATES_PROPERTY);
        return candidate != null ? Paths.get(candidate, new String[0]) : DEFAULT_CA_CERTIFICATES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileWatchingX509ExtendedTrustManager getContainerTrustManager() {
        Object object = MONITOR;
        synchronized (object) {
            if (CACHED_CONTAINER_TRUST_MANAGER == null && this.certificates != null && Files.exists(this.certificates, new LinkOption[0])) {
                this.logger.info(String.format("Adding TrustManager for %s", this.certificates));
                CACHED_CONTAINER_TRUST_MANAGER = new FileWatchingX509ExtendedTrustManager(this.certificates, this.getTrustManagerFactory());
            }
            return CACHED_CONTAINER_TRUST_MANAGER;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509ExtendedTrustManager getSystemTrustManager() {
        Object object = MONITOR;
        synchronized (object) {
            if (this.cachedSystemTrustManager == null) {
                for (TrustManager candidate : this.systemTrustManagerFactory.getTrustManagers()) {
                    if (!(candidate instanceof X509ExtendedTrustManager)) continue;
                    this.logger.info("Adding System Trust Manager");
                    this.cachedSystemTrustManager = (X509ExtendedTrustManager)candidate;
                    break;
                }
            }
            return this.cachedSystemTrustManager;
        }
    }

    private TrustManagerFactory getTrustManagerFactory() {
        try {
            return TrustManagerFactory.getInstance(this.algorithm, "SunJSSE");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateSystemTrustManager() {
        Object object = MONITOR;
        synchronized (object) {
            this.cachedSystemTrustManager = null;
        }
    }

    public static final class SimpleFactory
    extends CloudFoundryContainerTrustManagerFactory {
        public SimpleFactory() throws NoSuchProviderException, NoSuchAlgorithmException {
            this(CloudFoundryContainerTrustManagerFactory.getCertificatesLocation());
        }

        SimpleFactory(Path certificates) throws NoSuchAlgorithmException, NoSuchProviderException {
            super("SunX509", certificates);
        }
    }

    public static final class PKIXFactory
    extends CloudFoundryContainerTrustManagerFactory {
        public PKIXFactory() throws NoSuchProviderException, NoSuchAlgorithmException {
            this(CloudFoundryContainerTrustManagerFactory.getCertificatesLocation());
        }

        PKIXFactory(Path certificates) throws NoSuchAlgorithmException, NoSuchProviderException {
            super("PKIX", certificates);
        }
    }
}

