/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.security;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;

final class DelegatingX509ExtendedKeyManager
extends X509ExtendedKeyManager {
    private final List<X509ExtendedKeyManager> delegates;

    DelegatingX509ExtendedKeyManager(List<X509ExtendedKeyManager> delegates) {
        this.delegates = delegates;
    }

    @Override
    public String chooseClientAlias(final String[] strings, final Principal[] principals, final Socket socket) {
        return this.with(new Function<String>(){

            @Override
            public String apply(X509ExtendedKeyManager delegate) {
                return delegate.chooseClientAlias(strings, principals, socket);
            }
        });
    }

    @Override
    public String chooseEngineClientAlias(final String[] strings, final Principal[] principals, final SSLEngine sslEngine) {
        return this.with(new Function<String>(){

            @Override
            public String apply(X509ExtendedKeyManager delegate) {
                return delegate.chooseEngineClientAlias(strings, principals, sslEngine);
            }
        });
    }

    @Override
    public String chooseEngineServerAlias(final String s, final Principal[] principals, final SSLEngine sslEngine) {
        return this.with(new Function<String>(){

            @Override
            public String apply(X509ExtendedKeyManager delegate) {
                return delegate.chooseEngineServerAlias(s, principals, sslEngine);
            }
        });
    }

    @Override
    public String chooseServerAlias(final String s, final Principal[] principals, final Socket socket) {
        return this.with(new Function<String>(){

            @Override
            public String apply(X509ExtendedKeyManager delegate) {
                return delegate.chooseServerAlias(s, principals, socket);
            }
        });
    }

    @Override
    public X509Certificate[] getCertificateChain(final String s) {
        return this.with(new Function<X509Certificate[]>(){

            @Override
            public X509Certificate[] apply(X509ExtendedKeyManager delegate) {
                return delegate.getCertificateChain(s);
            }
        });
    }

    @Override
    public String[] getClientAliases(final String s, final Principal[] principals) {
        return this.collect(new Function<String[]>(){

            @Override
            public String[] apply(X509ExtendedKeyManager delegate) {
                return delegate.getClientAliases(s, principals);
            }
        });
    }

    @Override
    public PrivateKey getPrivateKey(final String s) {
        return this.with(new Function<PrivateKey>(){

            @Override
            public PrivateKey apply(X509ExtendedKeyManager delegate) {
                return delegate.getPrivateKey(s);
            }
        });
    }

    @Override
    public String[] getServerAliases(final String s, final Principal[] principals) {
        return this.collect(new Function<String[]>(){

            @Override
            public String[] apply(X509ExtendedKeyManager delegate) {
                return delegate.getServerAliases(s, principals);
            }
        });
    }

    int size() {
        return this.delegates.size();
    }

    private String[] collect(Function<String[]> function) {
        ArrayList collected = new ArrayList();
        for (X509ExtendedKeyManager delegate : this.delegates) {
            String[] candidate = function.apply(delegate);
            if (candidate == null) continue;
            Collections.addAll(collected, candidate);
        }
        return collected.toArray(new String[collected.size()]);
    }

    private <T> T with(Function<T> function) {
        for (X509ExtendedKeyManager delegate : this.delegates) {
            T candidate = function.apply(delegate);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    private static interface Function<T> {
        public T apply(X509ExtendedKeyManager var1);
    }
}

