/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.security;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;

final class DelegatingX509ExtendedTrustManager
extends X509ExtendedTrustManager {
    private final List<X509ExtendedTrustManager> delegates;

    DelegatingX509ExtendedTrustManager(List<X509ExtendedTrustManager> delegates) {
        this.delegates = delegates;
    }

    @Override
    public void checkClientTrusted(final X509Certificate[] x509Certificates, final String s, final Socket socket) throws CertificateException {
        this.with(new Consumer(){

            @Override
            public void accept(X509ExtendedTrustManager delegate) throws CertificateException {
                delegate.checkClientTrusted(x509Certificates, s, socket);
            }
        });
    }

    @Override
    public void checkClientTrusted(final X509Certificate[] x509Certificates, final String s) throws CertificateException {
        this.with(new Consumer(){

            @Override
            public void accept(X509ExtendedTrustManager delegate) throws CertificateException {
                delegate.checkClientTrusted(x509Certificates, s);
            }
        });
    }

    @Override
    public void checkClientTrusted(final X509Certificate[] x509Certificates, final String s, final SSLEngine sslEngine) throws CertificateException {
        this.with(new Consumer(){

            @Override
            public void accept(X509ExtendedTrustManager delegate) throws CertificateException {
                delegate.checkClientTrusted(x509Certificates, s, sslEngine);
            }
        });
    }

    @Override
    public void checkServerTrusted(final X509Certificate[] x509Certificates, final String s, final Socket socket) throws CertificateException {
        this.with(new Consumer(){

            @Override
            public void accept(X509ExtendedTrustManager delegate) throws CertificateException {
                delegate.checkServerTrusted(x509Certificates, s, socket);
            }
        });
    }

    @Override
    public void checkServerTrusted(final X509Certificate[] x509Certificates, final String s) throws CertificateException {
        this.with(new Consumer(){

            @Override
            public void accept(X509ExtendedTrustManager delegate) throws CertificateException {
                delegate.checkServerTrusted(x509Certificates, s);
            }
        });
    }

    @Override
    public void checkServerTrusted(final X509Certificate[] x509Certificates, final String s, final SSLEngine sslEngine) throws CertificateException {
        this.with(new Consumer(){

            @Override
            public void accept(X509ExtendedTrustManager delegate) throws CertificateException {
                delegate.checkServerTrusted(x509Certificates, s, sslEngine);
            }
        });
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.collect(new Function(){

            @Override
            public X509Certificate[] apply(X509ExtendedTrustManager delegate) {
                return delegate.getAcceptedIssuers();
            }
        });
    }

    int size() {
        return this.delegates.size();
    }

    private X509Certificate[] collect(Function function) {
        ArrayList collected = new ArrayList();
        for (X509ExtendedTrustManager delegate : this.delegates) {
            X509Certificate[] candidate = function.apply(delegate);
            if (candidate == null) continue;
            Collections.addAll(collected, candidate);
        }
        return collected.toArray(new X509Certificate[collected.size()]);
    }

    private void with(Consumer consumer) throws CertificateException {
        CertificateException exception = null;
        for (X509ExtendedTrustManager delegate : this.delegates) {
            try {
                consumer.accept(delegate);
                return;
            }
            catch (CertificateException e) {
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private static interface Function {
        public X509Certificate[] apply(X509ExtendedTrustManager var1);
    }

    private static interface Consumer {
        public void accept(X509ExtendedTrustManager var1) throws CertificateException;
    }
}

