/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.security;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

final class FileWatcher
implements Runnable,
Thread.UncaughtExceptionHandler,
ThreadFactory {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Runnable callback;
    private final AtomicInteger counter = new AtomicInteger();
    private final ExecutorService executorService;
    private final Path source;

    FileWatcher(Path source, Runnable callback) {
        this.callback = callback;
        this.executorService = Executors.newSingleThreadExecutor(this);
        this.source = source;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(r);
        thread.setDaemon(true);
        thread.setName(String.format("file-watcher-%s-%d", this.source.getName(this.source.getNameCount() - 1), this.counter.getAndIncrement()));
        thread.setUncaughtExceptionHandler(this);
        return thread;
    }

    @Override
    public void run() {
        WatchKey expected;
        WatchService watchService;
        this.logger.info(String.format("Start watching %s", this.source));
        try {
            watchService = this.source.getFileSystem().newWatchService();
            expected = this.source.getParent().register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Unable to setup file watcher", e);
            return;
        }
        try {
            WatchKey actual;
            while (true) {
                this.logger.fine("Waiting for event");
                actual = watchService.take();
                if (!actual.equals(expected)) {
                    this.logger.warning(String.format("Unknown watch key: %s", actual));
                    continue;
                }
                for (WatchEvent<?> watchEvent : actual.pollEvents()) {
                    Path changed = (Path)watchEvent.context();
                    if (!this.source.getFileName().equals(changed)) {
                        this.logger.fine(String.format("Discarding unimportant file change: %s", changed));
                        continue;
                    }
                    this.callback.run();
                }
                if (!actual.reset()) break;
            }
            this.logger.warning(String.format("Watch key is no longer valid: %s", actual));
        }
        catch (InterruptedException e) {
            this.logger.warning("Thread interrupted");
            Thread.currentThread().interrupt();
        }
        this.logger.info(String.format("Stop watching %s", this.source));
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.logger.log(Level.WARNING, "Suppressing watch error", e);
        this.watch();
    }

    void watch() {
        this.executorService.execute(this);
    }
}

