/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.security;

import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.concurrent.atomic.AtomicInteger;

final class KeyStoreEntryCollector {
    private static final AtomicInteger COUNTER = new AtomicInteger();

    KeyStoreEntryCollector() {
    }

    static KeyStore accumulate(KeyStore keyStore, Certificate certificate) throws KeyStoreException {
        keyStore.setCertificateEntry(KeyStoreEntryCollector.getAlias(), certificate);
        return keyStore;
    }

    static KeyStore accumulate(KeyStore keyStore, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        keyStore.setKeyEntry(KeyStoreEntryCollector.getAlias(), key, password, chain);
        return keyStore;
    }

    static KeyStore identity() throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null);
        return keyStore;
    }

    private static String getAlias() {
        return String.format("cloud-foundry-container-%03d", COUNTER.getAndIncrement());
    }
}

