/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.security;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.cloudfoundry.security.org.bouncycastle.cert.X509CertificateHolder;
import org.cloudfoundry.security.org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.cloudfoundry.security.org.bouncycastle.openssl.PEMParser;

final class X509CertificateFactory {
    private static final JcaX509CertificateConverter CONVERTER = new JcaX509CertificateConverter();

    X509CertificateFactory() {
    }

    static List<X509Certificate> generate(Path path) throws IOException, CertificateException {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        try (BufferedReader in = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            Object certificate;
            PEMParser parser = new PEMParser(in);
            while ((certificate = parser.readObject()) != null) {
                if (!(certificate instanceof X509CertificateHolder)) {
                    throw new IllegalStateException(String.format("%s contains an artifact that is not a certificate: %s", path, certificate));
                }
                certificates.add(CONVERTER.getCertificate((X509CertificateHolder)certificate));
            }
        }
        return certificates;
    }
}

