/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.security.org.bouncycastle.asn1.x500;

import org.cloudfoundry.security.org.bouncycastle.asn1.ASN1Encodable;
import org.cloudfoundry.security.org.bouncycastle.asn1.ASN1EncodableVector;
import org.cloudfoundry.security.org.bouncycastle.asn1.ASN1Object;
import org.cloudfoundry.security.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.cloudfoundry.security.org.bouncycastle.asn1.ASN1Primitive;
import org.cloudfoundry.security.org.bouncycastle.asn1.ASN1Set;
import org.cloudfoundry.security.org.bouncycastle.asn1.DERSequence;
import org.cloudfoundry.security.org.bouncycastle.asn1.DERSet;
import org.cloudfoundry.security.org.bouncycastle.asn1.x500.AttributeTypeAndValue;

public class RDN
extends ASN1Object {
    private ASN1Set values;

    private RDN(ASN1Set aSN1Set) {
        this.values = aSN1Set;
    }

    public static RDN getInstance(Object object) {
        if (object instanceof RDN) {
            return (RDN)object;
        }
        if (object != null) {
            return new RDN(ASN1Set.getInstance(object));
        }
        return null;
    }

    public RDN(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(aSN1ObjectIdentifier);
        aSN1EncodableVector.add(aSN1Encodable);
        this.values = new DERSet(new DERSequence(aSN1EncodableVector));
    }

    public RDN(AttributeTypeAndValue attributeTypeAndValue) {
        this.values = new DERSet(attributeTypeAndValue);
    }

    public RDN(AttributeTypeAndValue[] attributeTypeAndValueArray) {
        this.values = new DERSet(attributeTypeAndValueArray);
    }

    public boolean isMultiValued() {
        return this.values.size() > 1;
    }

    public int size() {
        return this.values.size();
    }

    public AttributeTypeAndValue getFirst() {
        if (this.values.size() == 0) {
            return null;
        }
        return AttributeTypeAndValue.getInstance(this.values.getObjectAt(0));
    }

    public AttributeTypeAndValue[] getTypesAndValues() {
        AttributeTypeAndValue[] attributeTypeAndValueArray = new AttributeTypeAndValue[this.values.size()];
        for (int i = 0; i != attributeTypeAndValueArray.length; ++i) {
            attributeTypeAndValueArray[i] = AttributeTypeAndValue.getInstance(this.values.getObjectAt(i));
        }
        return attributeTypeAndValueArray;
    }

    public ASN1Primitive toASN1Primitive() {
        return this.values;
    }
}

