/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.metrics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.metrics.Application;
import org.cloudfoundry.metrics.CloudFoundryMetricsProperties;
import org.cloudfoundry.metrics.Instance;
import org.cloudfoundry.metrics.Metric;
import org.cloudfoundry.metrics.Payload;
import org.springframework.boot.actuate.endpoint.PublicMetrics;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;

final class CloudFoundryMetricsExporter
implements Runnable {
    private final Log logger = LogFactory.getLog(CloudFoundryMetricsExporter.class);
    private final Collection<PublicMetrics> metricsCollections;
    private final CloudFoundryMetricsProperties properties;
    private final RestOperations restOperations;
    private final ScheduledExecutorService scheduledExecutorService;
    private ScheduledFuture<?> execution;

    CloudFoundryMetricsExporter(Collection<PublicMetrics> metricsCollections, CloudFoundryMetricsProperties properties, RestOperations restOperations, ScheduledExecutorService scheduledExecutorService) {
        this.properties = properties;
        this.metricsCollections = metricsCollections;
        this.restOperations = restOperations;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Override
    public void run() {
        this.logger.debug((Object)"Sending Spring Boot metrics to PCF Metrics");
        List<Metric> metrics = CloudFoundryMetricsExporter.getMetrics(this.metricsCollections);
        HttpEntity<Payload> request = this.getRequest(CloudFoundryMetricsExporter.getPayload(this.properties.getApplicationId(), this.properties.getInstanceId(), this.properties.getInstanceIndex(), metrics));
        try {
            this.restOperations.postForEntity(this.properties.getEndpoint(), request, Void.class, new Object[0]);
            this.logger.debug((Object)"Sent Spring Boot metrics to PCF Metrics");
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to send Spring Boot metrics to PCF Metrics", (Throwable)e);
        }
    }

    @PostConstruct
    public void start() {
        this.execution = this.scheduledExecutorService.scheduleAtFixedRate(this, 0L, this.properties.getRate(), TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public void stop() {
        if (this.execution != null) {
            this.execution.cancel(true);
        }
        this.scheduledExecutorService.shutdownNow();
    }

    @PostConstruct
    void announce() {
        this.logger.info((Object)"Exporting Spring Boot metrics to PCF Metrics");
    }

    private static List<Metric> getMetrics(Collection<PublicMetrics> metricsCollections) {
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        for (PublicMetrics metricsCollection : metricsCollections) {
            for (org.springframework.boot.actuate.metrics.Metric metric : metricsCollection.metrics()) {
                metrics.add(new Metric(metric));
            }
        }
        return metrics;
    }

    private static Payload getPayload(String applicationId, String instanceId, String instanceIndex, List<Metric> metrics) {
        Instance instance = new Instance(instanceId, instanceIndex, metrics);
        Application application = new Application(applicationId, Collections.singletonList(instance));
        return new Payload(Collections.singletonList(application));
    }

    private HttpEntity<Payload> getRequest(Payload payload) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", this.properties.getAccessToken());
        return new HttpEntity((Object)payload, (MultiValueMap)headers);
    }
}

