/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.metrics;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.metrics.Metric;
import org.springframework.util.Assert;

final class Instance {
    private final String id;
    private final String index;
    private final List<Metric> metrics;

    Instance(String id, String index, List<Metric> metrics) {
        Assert.notNull((Object)id, (String)"id must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        Assert.notNull(metrics, (String)"metrics must not be null");
        this.id = id;
        this.index = index;
        this.metrics = metrics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Instance instance = (Instance)o;
        return Objects.equals(this.id, instance.id) && Objects.equals(this.index, instance.index) && Objects.equals(this.metrics, instance.metrics);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.index, this.metrics);
    }

    public String toString() {
        return "Instance{id='" + this.id + '\'' + ", index='" + this.index + '\'' + ", metrics=" + this.metrics + '}';
    }

    @JsonProperty(value="id")
    String getId() {
        return this.id;
    }

    @JsonProperty(value="index")
    String getIndex() {
        return this.index;
    }

    @JsonProperty(value="metrics")
    List<Metric> getMetrics() {
        return this.metrics;
    }
}

