/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.metrics;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.cloudfoundry.metrics.Type;
import org.springframework.util.Assert;

final class Metric {
    private final String name;
    private final Long timestamp;
    private final Type type;
    private final String unit;
    private final Number value;

    Metric(org.springframework.boot.actuate.metrics.Metric<?> metric) {
        this(metric.getName(), metric.getTimestamp().getTime(), Type.GAUGE, null, metric.getValue());
    }

    Metric(String name, Long timestamp, Type type, String unit, Number value) {
        Assert.notNull((Object)name, (String)"name must not be null");
        Assert.notNull((Object)timestamp, (String)"timestamp must not be null");
        Assert.notNull((Object)((Object)type), (String)"type must not be null");
        Assert.notNull((Object)value, (String)"value must not be null");
        this.name = name;
        this.timestamp = timestamp;
        this.type = type;
        this.unit = unit;
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metric metric = (Metric)o;
        return Objects.equals(this.name, metric.name) && Objects.equals(this.timestamp, metric.timestamp) && this.type == metric.type && Objects.equals(this.unit, metric.unit) && Objects.equals(this.value, metric.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.timestamp, this.type, this.unit, this.value});
    }

    public String toString() {
        return "Metric{name='" + this.name + '\'' + ", timestamp=" + this.timestamp + ", type=" + (Object)((Object)this.type) + ", unit='" + this.unit + '\'' + ", value=" + this.value + '}';
    }

    @JsonProperty(value="name")
    String getName() {
        return this.name;
    }

    @JsonProperty(value="timestamp")
    Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="type")
    Type getType() {
        return this.type;
    }

    @JsonProperty(value="unit")
    String getUnit() {
        return this.unit;
    }

    @JsonProperty(value="value")
    Number getValue() {
        return this.value;
    }
}

