/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.metrics;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.metrics.Instance;
import org.springframework.util.Assert;

final class Application {
    private final String id;
    private final List<Instance> instances;

    Application(String id, List<Instance> instances) {
        Assert.notNull((Object)id, (String)"id must not be null");
        Assert.notNull(instances, (String)"instances must not be null");
        this.id = id;
        this.instances = instances;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Application that = (Application)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.instances, that.instances);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.instances);
    }

    public String toString() {
        return "Application{id='" + this.id + '\'' + ", instances=" + this.instances + '}';
    }

    @JsonProperty(value="id")
    String getId() {
        return this.id;
    }

    @JsonProperty(value="instances")
    List<Instance> getInstances() {
        return this.instances;
    }
}

