/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.metrics;

import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.cloudfoundry.metrics.CloudFoundryMetricsExporter;
import org.cloudfoundry.metrics.CloudFoundryMetricsProperties;
import org.cloudfoundry.metrics.SkipSslVerificationHttpRequestFactory;
import org.springframework.boot.actuate.endpoint.PublicMetrics;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@ConditionalOnClass(value={RestTemplate.class, PublicMetrics.class})
@ConditionalOnCloudPlatform(value=CloudPlatform.CLOUD_FOUNDRY)
@ConditionalOnProperty(prefix="cloudfoundry.metrics", name={"accessToken", "applicationId", "instanceId", "instanceIndex", "endpoint"})
@Configuration
@EnableConfigurationProperties(value={CloudFoundryMetricsProperties.class})
class CloudFoundryMetricsAutoConfiguration {
    CloudFoundryMetricsAutoConfiguration() {
    }

    @Bean
    CloudFoundryMetricsExporter cloudFoundryMetricWriter(CloudFoundryMetricsProperties properties, Collection<PublicMetrics> publicMetrics) {
        return new CloudFoundryMetricsExporter(publicMetrics, properties, (RestOperations)this.restTemplate(properties), this.scheduledExecutorService());
    }

    private RestTemplate restTemplate(CloudFoundryMetricsProperties properties) {
        if (properties.isSkipSslValidation()) {
            return new RestTemplate((ClientHttpRequestFactory)new SkipSslVerificationHttpRequestFactory());
        }
        return new RestTemplate();
    }

    private ScheduledExecutorService scheduledExecutorService() {
        return Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, String.format("cloudfoundry-metrics-exporter-%d", this.counter.getAndIncrement()));
                thread.setDaemon(true);
                return thread;
            }
        });
    }
}

