/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.metrics;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.metrics.Application;
import org.cloudfoundry.metrics.CloudFoundryMetricsProperties;
import org.cloudfoundry.metrics.Instance;
import org.cloudfoundry.metrics.Metric;
import org.cloudfoundry.metrics.MetricCache;
import org.cloudfoundry.metrics.Payload;
import org.springframework.boot.actuate.endpoint.PublicMetrics;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.client.RestOperations;

final class CloudFoundryMetricsExporter
implements Runnable {
    private static final String RETRY_AFTER = "X-RateLimit-Retry-After";
    private final Log logger = LogFactory.getLog(CloudFoundryMetricsExporter.class);
    private final MetricCache cache = new MetricCache();
    private final Collection<PublicMetrics> metricsCollections;
    private final CloudFoundryMetricsProperties properties;
    private final RestOperations restOperations;
    private final ScheduledExecutorService scheduledExecutorService;
    private ScheduledFuture<?> execution;
    private volatile Long retryAfter;

    CloudFoundryMetricsExporter(Collection<PublicMetrics> metricsCollections, CloudFoundryMetricsProperties properties, RestOperations restOperations, ScheduledExecutorService scheduledExecutorService) {
        this.properties = properties;
        this.metricsCollections = metricsCollections;
        this.restOperations = restOperations;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Override
    public void run() {
        if (this.retryAfter != null && this.retryAfter > System.currentTimeMillis()) {
            this.logger.debug((Object)"Skipping sending Spring Boot metrics to Metrics Forwarder service");
            return;
        }
        this.logger.debug((Object)"Sending Spring Boot metrics to Metrics Forwarder service");
        List<Metric> metrics = this.getMetrics();
        try {
            this.restOperations.postForEntity(this.properties.getEndpoint(), this.getRequest(metrics), Void.class, new Object[0]);
            this.logger.debug((Object)"Sent Spring Boot metrics to Metrics Forwarder service");
            this.retryAfter = null;
        }
        catch (Exception e) {
            if (e instanceof HttpStatusCodeException) {
                HttpStatus statusCode = ((HttpStatusCodeException)e).getStatusCode();
                if (HttpStatus.UNPROCESSABLE_ENTITY == statusCode) {
                    this.logger.error((Object)"Failed to send Spring Boot metrics to Metrics Forwarder service due to unprocessable payload.  Discarding metrics.", (Throwable)e);
                } else if (HttpStatus.PAYLOAD_TOO_LARGE == statusCode) {
                    this.logger.error((Object)"Failed to send Spring Boot metrics to Metrics Forwarder service due to rate limiting.  Discarding metrics.", (Throwable)e);
                } else if (HttpStatus.TOO_MANY_REQUESTS == statusCode) {
                    this.logger.error((Object)"Failed to send Spring Boot metrics to Metrics Forwarder service due to rate limiting.  Caching metrics.", (Throwable)e);
                    this.cache.addAll(metrics);
                } else {
                    this.logger.error((Object)"Failed to send Spring Boot metrics to Metrics Forwarder service. Caching metrics.", (Throwable)e);
                    this.cache.addAll(metrics);
                }
            }
            this.retryAfter = this.getRetryAfter(e);
        }
    }

    @PostConstruct
    public void start() {
        this.execution = this.scheduledExecutorService.scheduleAtFixedRate(this, this.properties.getRate(), this.properties.getRate(), TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public void stop() {
        if (this.execution != null) {
            this.execution.cancel(true);
        }
        this.scheduledExecutorService.shutdownNow();
    }

    @PostConstruct
    void announce() {
        this.logger.info((Object)"Exporting Spring Boot metrics to Metrics Forwarder service");
    }

    private List<Metric> getMetrics() {
        List<Metric> metrics = this.cache.getAndClear();
        for (PublicMetrics metricsCollection : this.metricsCollections) {
            for (org.springframework.boot.actuate.metrics.Metric metric : metricsCollection.metrics()) {
                metrics.add(new Metric(metric));
            }
        }
        return metrics;
    }

    private Payload getPayload(List<Metric> metrics) {
        Instance instance = new Instance(this.properties.getInstanceId(), this.properties.getInstanceIndex(), metrics);
        Application application = new Application(this.properties.getApplicationId(), Collections.singletonList(instance));
        return new Payload(Collections.singletonList(application));
    }

    private HttpEntity<Payload> getRequest(List<Metric> metrics) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", this.properties.getAccessToken());
        return new HttpEntity((Object)this.getPayload(metrics), (MultiValueMap)headers);
    }

    private Long getRetryAfter(Exception candidate) {
        String retryAfter;
        if (candidate instanceof RestClientResponseException && (retryAfter = ((RestClientResponseException)candidate).getResponseHeaders().getFirst(RETRY_AFTER)) != null) {
            return System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(Long.parseLong(retryAfter));
        }
        return null;
    }
}

