/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.events.jpa;

import java.time.Instant;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import lombok.Generated;

@Entity
class JpaEventPublication {
    @Id
    @Column(length=16)
    private final UUID id;
    private final Instant publicationDate;
    private final String listenerId;
    private final String serializedEvent;
    private final Class<?> eventType;
    private Instant completionDate;

    static JpaEventPublication of(Instant publicationDate, String listenerId, Object serializedEvent, Class<?> eventType) {
        return new JpaEventPublication(UUID.randomUUID(), publicationDate, listenerId, serializedEvent.toString(), eventType);
    }

    JpaEventPublication markCompleted() {
        this.completionDate = Instant.now();
        return this;
    }

    @Generated
    public static JpaEventPublicationBuilder builder() {
        return new JpaEventPublicationBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public Instant getPublicationDate() {
        return this.publicationDate;
    }

    @Generated
    public String getListenerId() {
        return this.listenerId;
    }

    @Generated
    public String getSerializedEvent() {
        return this.serializedEvent;
    }

    @Generated
    public Class<?> getEventType() {
        return this.eventType;
    }

    @Generated
    public Instant getCompletionDate() {
        return this.completionDate;
    }

    @Generated
    public void setCompletionDate(Instant completionDate) {
        this.completionDate = completionDate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JpaEventPublication)) {
            return false;
        }
        JpaEventPublication other = (JpaEventPublication)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Instant this$publicationDate = this.getPublicationDate();
        Instant other$publicationDate = other.getPublicationDate();
        if (this$publicationDate == null ? other$publicationDate != null : !((Object)this$publicationDate).equals(other$publicationDate)) {
            return false;
        }
        String this$listenerId = this.getListenerId();
        String other$listenerId = other.getListenerId();
        if (this$listenerId == null ? other$listenerId != null : !this$listenerId.equals(other$listenerId)) {
            return false;
        }
        String this$serializedEvent = this.getSerializedEvent();
        String other$serializedEvent = other.getSerializedEvent();
        if (this$serializedEvent == null ? other$serializedEvent != null : !this$serializedEvent.equals(other$serializedEvent)) {
            return false;
        }
        Class<?> this$eventType = this.getEventType();
        Class<?> other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        Instant this$completionDate = this.getCompletionDate();
        Instant other$completionDate = other.getCompletionDate();
        return !(this$completionDate == null ? other$completionDate != null : !((Object)this$completionDate).equals(other$completionDate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JpaEventPublication;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Instant $publicationDate = this.getPublicationDate();
        result = result * 59 + ($publicationDate == null ? 43 : ((Object)$publicationDate).hashCode());
        String $listenerId = this.getListenerId();
        result = result * 59 + ($listenerId == null ? 43 : $listenerId.hashCode());
        String $serializedEvent = this.getSerializedEvent();
        result = result * 59 + ($serializedEvent == null ? 43 : $serializedEvent.hashCode());
        Class<?> $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        Instant $completionDate = this.getCompletionDate();
        result = result * 59 + ($completionDate == null ? 43 : ((Object)$completionDate).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JpaEventPublication(id=" + this.getId() + ", publicationDate=" + this.getPublicationDate() + ", listenerId=" + this.getListenerId() + ", serializedEvent=" + this.getSerializedEvent() + ", eventType=" + this.getEventType() + ", completionDate=" + this.getCompletionDate() + ")";
    }

    @Generated
    public JpaEventPublication() {
        this.id = null;
        this.publicationDate = null;
        this.listenerId = null;
        this.serializedEvent = null;
        this.eventType = null;
    }

    @Generated
    private JpaEventPublication(UUID id, Instant publicationDate, String listenerId, String serializedEvent, Class<?> eventType) {
        this.id = id;
        this.publicationDate = publicationDate;
        this.listenerId = listenerId;
        this.serializedEvent = serializedEvent;
        this.eventType = eventType;
    }

    @Generated
    public static class JpaEventPublicationBuilder {
        @Generated
        private Instant publicationDate;
        @Generated
        private String listenerId;
        @Generated
        private Object serializedEvent;
        @Generated
        private Class<?> eventType;

        @Generated
        JpaEventPublicationBuilder() {
        }

        @Generated
        public JpaEventPublicationBuilder publicationDate(Instant publicationDate) {
            this.publicationDate = publicationDate;
            return this;
        }

        @Generated
        public JpaEventPublicationBuilder listenerId(String listenerId) {
            this.listenerId = listenerId;
            return this;
        }

        @Generated
        public JpaEventPublicationBuilder serializedEvent(Object serializedEvent) {
            this.serializedEvent = serializedEvent;
            return this;
        }

        @Generated
        public JpaEventPublicationBuilder eventType(Class<?> eventType) {
            this.eventType = eventType;
            return this;
        }

        @Generated
        public JpaEventPublication build() {
            return JpaEventPublication.of(this.publicationDate, this.listenerId, this.serializedEvent, this.eventType);
        }

        @Generated
        public String toString() {
            return "JpaEventPublication.JpaEventPublicationBuilder(publicationDate=" + this.publicationDate + ", listenerId=" + this.listenerId + ", serializedEvent=" + this.serializedEvent + ", eventType=" + this.eventType + ")";
        }
    }
}

