/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.events.jpa;

import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.moduliths.events.CompletableEventPublication;
import org.moduliths.events.EventPublication;
import org.moduliths.events.EventPublicationRegistry;
import org.moduliths.events.EventSerializer;
import org.moduliths.events.PublicationTargetIdentifier;
import org.moduliths.events.jpa.JpaEventPublication;
import org.moduliths.events.jpa.JpaEventPublicationRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

class JpaEventPublicationRegistry
implements EventPublicationRegistry,
DisposableBean {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(JpaEventPublicationRegistry.class);
    @NonNull
    private final JpaEventPublicationRepository events;
    @NonNull
    private final EventSerializer serializer;

    public void store(Object event, Stream<PublicationTargetIdentifier> listeners) {
        listeners.map((? super T it) -> CompletableEventPublication.of((Object)event, (PublicationTargetIdentifier)it)).map(this::map).forEach(it -> this.events.create((JpaEventPublication)it));
    }

    public Iterable<EventPublication> findIncompletePublications() {
        List<EventPublication> result = this.events.findByCompletionDateIsNull().stream().map((? super T it) -> JpaEventPublicationAdapter.of(it, this.serializer)).collect(Collectors.toList());
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void markCompleted(Object event, PublicationTargetIdentifier listener) {
        Assert.notNull((Object)event, (String)"Domain event must not be null!");
        Assert.notNull((Object)listener, (String)"Listener identifier must not be null!");
        this.events.findBySerializedEventAndListenerId(this.serializer.serialize(event), listener.toString()).map(JpaEventPublicationRegistry::logCompleted).ifPresent(it -> this.events.update(it.markCompleted()));
    }

    public void destroy() throws Exception {
        List<JpaEventPublication> publications = this.events.findByCompletionDateIsNull();
        if (publications.isEmpty()) {
            LOG.info("No publications outstanding!");
            return;
        }
        LOG.info("Shutting down with the following publications left unfinished:");
        for (int i = 0; i < publications.size(); ++i) {
            String prefix = i + 1 == publications.size() ? "\u2514\u2500" : "\u251c\u2500";
            JpaEventPublication it = publications.get(i);
            LOG.info("{} {} - {} - {}", new Object[]{prefix, it.getId(), it.getEventType().getName(), it.getListenerId()});
        }
    }

    private JpaEventPublication map(EventPublication publication) {
        JpaEventPublication result = JpaEventPublication.builder().eventType(publication.getEvent().getClass()).publicationDate(publication.getPublicationDate()).listenerId(publication.getTargetIdentifier().toString()).serializedEvent(this.serializer.serialize(publication.getEvent()).toString()).build();
        LOG.debug("Registering publication of {} with id {} for {}.", new Object[]{result.getEventType(), result.getId(), result.getListenerId()});
        return result;
    }

    private static JpaEventPublication logCompleted(JpaEventPublication publication) {
        LOG.debug("Marking publication of event {} with id {} to listener {} completed.", new Object[]{publication.getEventType(), publication.getId(), publication.getListenerId()});
        return publication;
    }

    @Generated
    public JpaEventPublicationRegistry(@NonNull JpaEventPublicationRepository events, @NonNull EventSerializer serializer) {
        if (events == null) {
            throw new IllegalArgumentException("events is marked non-null but is null");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer is marked non-null but is null");
        }
        this.events = events;
        this.serializer = serializer;
    }

    static class JpaEventPublicationAdapter
    implements EventPublication {
        private final JpaEventPublication publication;
        private final EventSerializer serializer;
        private Object deserializedEvent;

        public Object getEvent() {
            if (this.deserializedEvent == null) {
                this.deserializedEvent = this.serializer.deserialize((Object)this.publication.getSerializedEvent(), this.publication.getEventType());
            }
            return this.deserializedEvent;
        }

        public PublicationTargetIdentifier getTargetIdentifier() {
            return PublicationTargetIdentifier.of((String)this.publication.getListenerId());
        }

        public Instant getPublicationDate() {
            return this.publication.getPublicationDate();
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JpaEventPublicationAdapter)) {
                return false;
            }
            JpaEventPublicationAdapter other = (JpaEventPublicationAdapter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            JpaEventPublication this$publication = this.publication;
            JpaEventPublication other$publication = other.publication;
            if (this$publication == null ? other$publication != null : !((Object)this$publication).equals(other$publication)) {
                return false;
            }
            EventSerializer this$serializer = this.serializer;
            EventSerializer other$serializer = other.serializer;
            if (this$serializer == null ? other$serializer != null : !this$serializer.equals(other$serializer)) {
                return false;
            }
            Object this$deserializedEvent = this.deserializedEvent;
            Object other$deserializedEvent = other.deserializedEvent;
            return !(this$deserializedEvent == null ? other$deserializedEvent != null : !this$deserializedEvent.equals(other$deserializedEvent));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JpaEventPublicationAdapter;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JpaEventPublication $publication = this.publication;
            result = result * 59 + ($publication == null ? 43 : ((Object)$publication).hashCode());
            EventSerializer $serializer = this.serializer;
            result = result * 59 + ($serializer == null ? 43 : $serializer.hashCode());
            Object $deserializedEvent = this.deserializedEvent;
            result = result * 59 + ($deserializedEvent == null ? 43 : $deserializedEvent.hashCode());
            return result;
        }

        @Generated
        private JpaEventPublicationAdapter(JpaEventPublication publication, EventSerializer serializer) {
            this.publication = publication;
            this.serializer = serializer;
        }

        @Generated
        public static JpaEventPublicationAdapter of(JpaEventPublication publication, EventSerializer serializer) {
            return new JpaEventPublicationAdapter(publication, serializer);
        }
    }
}

