/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.observability;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.moduliths.model.Modules;
import org.moduliths.observability.ApplicationRuntime;
import org.moduliths.observability.ModulesRuntime;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.util.Assert;

class ModuleTracingSupport
implements BeanClassLoaderAware {
    private final Supplier<Modules> modules;
    private final ApplicationRuntime context;
    private ClassLoader classLoader;

    protected ModuleTracingSupport(ApplicationRuntime context) {
        Assert.notNull((Object)context, (String)"ApplicationContext must not be null!");
        this.modules = ModulesRuntime.of(context);
        this.context = context;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected final Modules getModules() {
        try {
            return this.modules.get();
        }
        catch (Exception o_O) {
            throw new RuntimeException(o_O);
        }
    }

    protected final Class<?> getBeanUserClass(Object bean, String beanName) {
        return this.context.getUserClass(bean, beanName);
    }

    protected final Object addAdvisor(Object bean, Advisor advisor) {
        return this.addAdvisor(bean, advisor, __ -> {});
    }

    protected final Object addAdvisor(Object bean, Advisor advisor, Consumer<ProxyFactory> customizer) {
        if (Advised.class.isInstance(bean)) {
            ((Advised)bean).addAdvisor(0, advisor);
            return bean;
        }
        ProxyFactory factory = new ProxyFactory(bean);
        customizer.accept(factory);
        factory.addAdvisor(advisor);
        return factory.getProxy(this.classLoader);
    }
}

