/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.observability;

import lombok.Generated;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.moduliths.model.Module;
import org.moduliths.model.Modules;
import org.moduliths.observability.ApplicationRuntime;
import org.moduliths.observability.DefaultObservedModule;
import org.moduliths.observability.ModuleEntryInterceptor;
import org.moduliths.observability.ModuleTracingSupport;
import org.springframework.aop.Advisor;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.rest.webmvc.BasePathAwareController;
import org.springframework.data.rest.webmvc.RootResourceInformation;

public class SpringDataRestModuleTracingBeanPostProcessor
extends ModuleTracingSupport
implements BeanPostProcessor {
    private final Tracer tracer;
    private final ApplicationRuntime runtime;

    public SpringDataRestModuleTracingBeanPostProcessor(ApplicationRuntime runtime, Tracer tracer) {
        super(runtime);
        this.tracer = tracer;
        this.runtime = runtime;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class<?> type = this.runtime.getUserClass(bean, beanName);
        if (!AnnotatedElementUtils.hasAnnotation(type, BasePathAwareController.class)) {
            return bean;
        }
        DataRestControllerInterceptor interceptor = new DataRestControllerInterceptor(this.getModules(), this.tracer);
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor((Advice)interceptor);
        return this.addAdvisor(bean, (Advisor)advisor, it -> it.setProxyTargetClass(true));
    }

    private static class DataRestControllerInterceptor
    implements MethodInterceptor {
        private final Modules modules;
        private final Tracer tracer;

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Module module = this.getModuleFrom(invocation.getArguments());
            if (module == null) {
                return invocation.proceed();
            }
            DefaultObservedModule observed = new DefaultObservedModule(module);
            return ModuleEntryInterceptor.of(observed, this.tracer).invoke(invocation);
        }

        private Module getModuleFrom(Object[] arguments) {
            for (Object argument : arguments) {
                if (!RootResourceInformation.class.isInstance(arguments)) continue;
                RootResourceInformation info = (RootResourceInformation)argument;
                return this.modules.getModuleByType(info.getDomainType().getName()).orElse(null);
            }
            return null;
        }

        @Generated
        public DataRestControllerInterceptor(Modules modules, Tracer tracer) {
            this.modules = modules;
            this.tracer = tracer;
        }
    }
}

