/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.observability;

import com.tngtech.archunit.core.domain.JavaClass;
import java.lang.reflect.Method;
import java.util.Arrays;
import lombok.Generated;
import org.aopalliance.intercept.MethodInvocation;
import org.moduliths.model.ArchitecturallyEvidentType;
import org.moduliths.model.FormatableJavaClass;
import org.moduliths.model.Module;
import org.moduliths.model.Modules;
import org.moduliths.model.SpringBean;
import org.moduliths.observability.ObservedModule;
import org.moduliths.observability.ObservedModuleType;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.aop.framework.Advised;

class DefaultObservedModule
implements ObservedModule {
    private final Module module;

    @Override
    public String getName() {
        return this.module.getName();
    }

    @Override
    public String getDisplayName() {
        return this.module.getDisplayName();
    }

    @Override
    public String getInvokedMethod(MethodInvocation invocation) {
        Method method = invocation.getMethod();
        if (this.module.contains(method.getDeclaringClass())) {
            return DefaultObservedModule.toString(invocation.getMethod(), this.module);
        }
        if (!ProxyMethodInvocation.class.isInstance(invocation)) {
            return DefaultObservedModule.toString(invocation.getMethod(), this.module);
        }
        Advised advised = (Advised)((ProxyMethodInvocation)invocation).getProxy();
        Class targetClass = advised.getTargetClass();
        if (this.module.contains(targetClass)) {
            return DefaultObservedModule.toString(targetClass, method, this.module);
        }
        for (Class type : advised.getProxiedInterfaces()) {
            if (!this.module.contains(type) || !Arrays.asList(type.getMethods()).contains(method)) continue;
            return DefaultObservedModule.toString(type, method, this.module);
        }
        return DefaultObservedModule.toString(invocation.getMethod(), this.module);
    }

    @Override
    public boolean exposes(JavaClass type) {
        return this.module.isExposed(type);
    }

    @Override
    public boolean isObservedModule(Module module) {
        return this.module.equals((Object)module);
    }

    @Override
    public ObservedModuleType getObservedModuleType(Class<?> type, Modules modules) {
        return this.module.getSpringBeans().stream().filter(it -> it.getFullyQualifiedTypeName().equals(type.getName())).map(SpringBean::toArchitecturallyEvidentType).findFirst().map(it -> new ObservedModuleType(modules, this, (ArchitecturallyEvidentType)it)).filter(ObservedModuleType::shouldBeTraced).orElse(null);
    }

    private static String toString(Method method, Module module) {
        return DefaultObservedModule.toString(method.getDeclaringClass(), method, module);
    }

    private static String toString(Class<?> type, Method method, Module module) {
        String typeName = module.getType(type.getName()).map(FormatableJavaClass::of).map(FormatableJavaClass::getAbbreviatedFullName).orElseGet(() -> type.getName());
        return String.format("%s.%s(\u2026)", typeName, method.getName());
    }

    @Generated
    public DefaultObservedModule(Module module) {
        this.module = module;
    }
}

