/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.observability;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.aopalliance.aop.Advice;
import org.moduliths.model.Modules;
import org.moduliths.observability.ApplicationRuntime;
import org.moduliths.observability.DefaultObservedModule;
import org.moduliths.observability.ModuleEntryInterceptor;
import org.moduliths.observability.ModuleTracingSupport;
import org.moduliths.observability.ObservedModule;
import org.moduliths.observability.ObservedModuleType;
import org.springframework.aop.Advisor;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.StaticMethodMatcher;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.sleuth.Tracer;

public class ModuleTracingBeanPostProcessor
extends ModuleTracingSupport
implements BeanPostProcessor {
    public static final String MODULE_BAGGAGE_KEY = "org.moduliths.module";
    private final ApplicationRuntime runtime;
    private final Tracer tracer;
    private final Map<String, Advisor> advisors = new HashMap<String, Advisor>();

    public ModuleTracingBeanPostProcessor(ApplicationRuntime runtime, Tracer tracer) {
        super(runtime);
        this.runtime = runtime;
        this.tracer = tracer;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class<?> type = this.getBeanUserClass(bean, beanName);
        if (!this.runtime.isApplicationClass(type) || !type.isInstance(bean)) {
            return bean;
        }
        Modules modules = this.getModules();
        return modules.getModuleByType(type.getName()).map(DefaultObservedModule::new).map(it -> {
            ObservedModuleType moduleType = it.getObservedModuleType(type, modules);
            return moduleType != null ? this.addAdvisor(bean, this.getOrBuildAdvisor((ObservedModule)it, moduleType)) : bean;
        }).orElse(bean);
    }

    private Advisor getOrBuildAdvisor(ObservedModule module, ObservedModuleType type) {
        return this.advisors.computeIfAbsent(module.getName(), __ -> {
            ModuleEntryInterceptor interceptor = ModuleEntryInterceptor.of(module, this.tracer);
            ObservableTypeMethodMatcher matcher = new ObservableTypeMethodMatcher(type);
            ComposablePointcut pointcut = new ComposablePointcut((MethodMatcher)matcher);
            return new DefaultPointcutAdvisor((Pointcut)pointcut, (Advice)interceptor);
        });
    }

    private static class ObservableTypeMethodMatcher
    extends StaticMethodMatcher {
        private final ObservedModuleType type;

        public boolean matches(Method method, Class<?> targetClass) {
            return this.type.getMethodsToIntercept().test(method);
        }

        @Generated
        public ObservableTypeMethodMatcher(ObservedModuleType type) {
            this.type = type;
        }
    }
}

