/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.observability;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import lombok.Generated;
import org.moduliths.model.Modules;
import org.moduliths.observability.ApplicationRuntime;

public class ModulesRuntime
implements Supplier<Modules> {
    private static final Map<String, ModulesRuntime> MODULES = new HashMap<String, ModulesRuntime>();
    private final Supplier<Modules> modules;
    private final ApplicationRuntime runtime;

    @Override
    public Modules get() {
        return this.modules.get();
    }

    boolean isApplicationClass(Class<?> type) {
        return this.runtime.isApplicationClass(type);
    }

    public static ModulesRuntime of(ApplicationRuntime runtime) {
        return MODULES.computeIfAbsent(runtime.getId(), it -> {
            Class<?> mainClass = runtime.getMainApplicationClass();
            Future<Modules> modules = Executors.newFixedThreadPool(1).submit(() -> Modules.of((Class)mainClass));
            return new ModulesRuntime(ModulesRuntime.toSupplier(modules), runtime);
        });
    }

    private static Supplier<Modules> toSupplier(Future<Modules> modules) {
        return () -> {
            try {
                return (Modules)modules.get();
            }
            catch (Exception o_O) {
                throw new RuntimeException(o_O);
            }
        };
    }

    @Generated
    public ModulesRuntime(Supplier<Modules> modules, ApplicationRuntime runtime) {
        this.modules = modules;
        this.runtime = runtime;
    }
}

