/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.observability;

import java.util.function.Supplier;
import lombok.Generated;
import org.moduliths.model.Module;
import org.moduliths.observability.ModulesRuntime;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.PayloadApplicationEvent;

public class ModuleEventListener
implements ApplicationListener<ApplicationEvent> {
    private final ModulesRuntime modules;
    private final Supplier<Tracer> tracer;

    public void onApplicationEvent(ApplicationEvent event) {
        if (!PayloadApplicationEvent.class.isInstance(event)) {
            return;
        }
        PayloadApplicationEvent foo = (PayloadApplicationEvent)event;
        Object object = foo.getPayload();
        Class<?> payloadType = object.getClass();
        if (!this.modules.isApplicationClass(payloadType)) {
            return;
        }
        Module moduleByType = this.modules.get().getModuleByType(payloadType.getSimpleName()).orElse(null);
        if (moduleByType == null) {
            return;
        }
        Span span = this.tracer.get().currentSpan();
        if (span == null) {
            return;
        }
        span.event("Published " + payloadType.getName());
    }

    @Generated
    public ModuleEventListener(ModulesRuntime modules, Supplier<Tracer> tracer) {
        this.modules = modules;
        this.tracer = tracer;
    }
}

