/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.observability;

import java.lang.reflect.Method;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.Generated;
import org.moduliths.model.ArchitecturallyEvidentType;
import org.moduliths.model.Module;
import org.moduliths.model.Modules;
import org.moduliths.observability.ObservedModule;

public class ObservedModuleType {
    private final Modules modules;
    private final ObservedModule module;
    private final ArchitecturallyEvidentType type;

    public boolean shouldBeTraced() {
        boolean isApiType = this.module.exposes(this.type.getType());
        return this.type.isController() || this.listensToOtherModulesEvents() || isApiType;
    }

    public Predicate<Method> getMethodsToIntercept() {
        if (!this.type.isEventListener()) {
            return it -> true;
        }
        return candidate -> this.type.getReferenceMethods().map(ArchitecturallyEvidentType.ReferenceMethod::getMethod).anyMatch(it -> it.reflect().equals(candidate));
    }

    private boolean listensToOtherModulesEvents() {
        if (!this.type.isEventListener()) {
            return false;
        }
        return this.type.getReferenceTypes().flatMap(it -> this.modules.getModuleByType(it).map(Stream::of).orElseGet(Stream::empty)).findFirst().map(it -> !this.module.isObservedModule((Module)it)).orElse(true);
    }

    @Generated
    public ObservedModuleType(Modules modules, ObservedModule module, ArchitecturallyEvidentType type) {
        this.modules = modules;
        this.module = module;
        this.type = type;
    }
}

