/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.observability.autoconfigure;

import brave.TracingCustomizer;
import brave.baggage.BaggageField;
import brave.baggage.BaggagePropagationConfig;
import brave.baggage.BaggagePropagationCustomizer;
import brave.handler.MutableSpan;
import brave.handler.SpanHandler;
import brave.propagation.TraceContext;
import org.moduliths.observability.ApplicationRuntime;
import org.moduliths.observability.ModuleEventListener;
import org.moduliths.observability.ModuleTracingBeanPostProcessor;
import org.moduliths.observability.ModulesRuntime;
import org.moduliths.observability.autoconfigure.SpringBootApplicationRuntime;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
class ModuleObservabilityAutoConfiguration {
    ModuleObservabilityAutoConfiguration() {
    }

    @Bean
    static SpringBootApplicationRuntime modulithsApplicationRuntime(ApplicationContext context) {
        return new SpringBootApplicationRuntime(context);
    }

    @Bean
    static ModuleTracingBeanPostProcessor moduleTracingBeanPostProcessor(ApplicationRuntime runtime, Tracer tracer) {
        return new ModuleTracingBeanPostProcessor(runtime, tracer);
    }

    @Bean
    static ModuleEventListener tracingModuleEventListener(ApplicationRuntime runtime, ObjectProvider<Tracer> tracer) {
        return new ModuleEventListener(ModulesRuntime.of(runtime), () -> (Tracer)tracer.getObject());
    }

    @ConditionalOnClass(value={TracingCustomizer.class})
    static class ModulithsBraveIntegrationAutoConfiguration {
        ModulithsBraveIntegrationAutoConfiguration() {
        }

        @Bean
        BaggagePropagationCustomizer moduleBaggagePropagationCustomizer() {
            return builder -> builder.add((BaggagePropagationConfig)BaggagePropagationConfig.SingleBaggageField.local((BaggageField)BaggageField.create((String)"org.moduliths.module")));
        }

        @Bean
        SpanHandler spanHandler() {
            return new SpanHandler(){

                public boolean end(TraceContext context, MutableSpan span, SpanHandler.Cause cause) {
                    String value = span.tag("org.moduliths.module");
                    if (value != null) {
                        span.localServiceName(value);
                        return true;
                    }
                    BaggageField field = BaggageField.getByName((TraceContext)context, (String)"org.moduliths.module");
                    value = field.getValue();
                    if (value != null) {
                        span.localServiceName(value);
                    }
                    return true;
                }
            };
        }
    }
}

