/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.observability.autoconfigure;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.moduliths.observability.ApplicationRuntime;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ClassUtils;

class SpringBootApplicationRuntime
implements ApplicationRuntime {
    private static final Map<String, Boolean> APPLICATION_CLASSES = new ConcurrentHashMap<String, Boolean>();
    private final ApplicationContext context;

    @Override
    public String getId() {
        return this.context.getId();
    }

    @Override
    public Class<?> getMainApplicationClass() {
        String[] mainBeanNames = this.context.getBeanNamesForAnnotation(SpringBootApplication.class);
        return this.context.getType(mainBeanNames[0]);
    }

    @Override
    public Class<?> getUserClass(Object bean, String beanName) {
        Class beanType = this.context.containsBean(beanName) ? this.context.getType(beanName) : bean.getClass();
        return ClassUtils.getUserClass((Class)beanType);
    }

    @Override
    public boolean isApplicationClass(Class<?> type) {
        return APPLICATION_CLASSES.computeIfAbsent(type.getName(), it -> {
            if (it.startsWith("org.springframework")) {
                return false;
            }
            return it.startsWith(this.getMainApplicationClass().getPackage().getName()) || AutoConfigurationPackages.get((BeanFactory)this.context).stream().anyMatch(pkg -> it.startsWith((String)pkg));
        });
    }

    @Generated
    public SpringBootApplicationRuntime(ApplicationContext context) {
        this.context = context;
    }
}

