/*
 * Decompiled with CFR 0.152.
 */
package link.thingscloud.spring.boot.common.redis.impl;

import io.lettuce.core.internal.LettuceLists;
import link.thingscloud.spring.boot.common.redis.DistributedRedisLimiter;
import link.thingscloud.spring.boot.common.util.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Component;

@Component
public class SimpleDistributedRedisLimiterImpl
implements DistributedRedisLimiter {
    private static final Logger log = LoggerFactory.getLogger(SimpleDistributedRedisLimiterImpl.class);
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    private static final String KEY_PREFIX = "simple:distributed:limiter:";
    private static final RedisScript<Long> SIMPLE_DISTRIBUTED_LIMITER_REDIS_SCRIPT = new DefaultRedisScript("if redis.call('HLEN', KEYS[1]) < tonumber(KEYS[2]) then  return redis.call('HSET', KEYS[1], ARGV[1], ARGV[2]) else return -1 end", Long.class);

    @Override
    public boolean tryAcquire(String key, String hashKey, int permits) {
        try {
            Long result = (Long)this.stringRedisTemplate.execute(SIMPLE_DISTRIBUTED_LIMITER_REDIS_SCRIPT, LettuceLists.newList((Object[])new String[]{KEY_PREFIX + key, String.valueOf(permits)}), new Object[]{hashKey, SystemClock.strNow()});
            return result != null && result > 0L;
        }
        catch (Exception e) {
            log.error("try acquire key [{}] hashKey [{}] permits [{}] failed, cause : ", new Object[]{key, hashKey, permits, e});
            return false;
        }
    }

    @Override
    public boolean tryRelease(String key, String hashKey) {
        return this.stringRedisTemplate.opsForHash().delete((Object)(KEY_PREFIX + key), new Object[]{hashKey}) == 1L;
    }
}

