/*
 * Decompiled with CFR 0.152.
 */
package ltd.dolink.arch.initializer;

import android.app.Application;
import androidx.annotation.NonNull;
import androidx.lifecycle.HasDefaultViewModelProviderFactory;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ProcessLifecycleOwner;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.ViewModelStoreOwner;

public class ApplicationOwner
implements LifecycleOwner,
ViewModelStoreOwner,
HasDefaultViewModelProviderFactory {
    private static ApplicationOwner applicationOwner;
    private final Application application;
    private final ViewModelStore viewModelStore;
    private final ViewModelProvider.Factory factory;

    public ApplicationOwner(Application application) {
        this.application = application;
        applicationOwner = this;
        this.viewModelStore = new ViewModelStore();
        this.factory = ViewModelProvider.AndroidViewModelFactory.getInstance((Application)application);
    }

    @NonNull
    public static ApplicationOwner getInstance() {
        return applicationOwner;
    }

    @NonNull
    public Application getApplication() {
        return this.application;
    }

    @NonNull
    public ViewModelStore getViewModelStore() {
        return this.viewModelStore;
    }

    @NonNull
    public Lifecycle getLifecycle() {
        return ProcessLifecycleOwner.get().getLifecycle();
    }

    @NonNull
    public ViewModelProvider.Factory getDefaultViewModelProviderFactory() {
        return this.factory;
    }
}

