/*
 * Decompiled with CFR 0.152.
 */
package ltd.dolink.arch.rxjava2;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import io.reactivex.subjects.Subject;
import java.io.Closeable;
import ltd.dolink.arch.Effect;
import ltd.dolink.arch.Intent;
import ltd.dolink.arch.State;
import ltd.dolink.arch.ViewEffect;
import ltd.dolink.arch.ViewModel;
import ltd.dolink.arch.ViewState;
import ltd.dolink.arch.rxjava2.RxViewEffect;
import ltd.dolink.arch.rxjava2.RxViewState;

public abstract class RxViewModel<STATE extends State, EFFECT extends Effect, INTENT extends Intent>
extends androidx.lifecycle.ViewModel
implements ViewModel<STATE, EFFECT, INTENT> {
    @NonNull
    private final RxViewState<STATE> viewState = this.initializeViewState();
    @NonNull
    private final RxViewEffect<EFFECT> viewEffect = this.initializeViewEffect();

    public RxViewModel() {
    }

    public RxViewModel(Closeable ... closeables) {
        super(closeables);
    }

    @NonNull
    protected RxViewState<STATE> initializeViewState() {
        return new RxViewState();
    }

    @NonNull
    protected RxViewEffect<EFFECT> initializeViewEffect() {
        return new RxViewEffect();
    }

    @NonNull
    protected Subject<STATE> state() {
        return this.viewState.state();
    }

    @NonNull
    protected Subject<EFFECT> effect() {
        return this.viewEffect.effect();
    }

    @NonNull
    public ViewState<STATE> viewState() {
        return this.viewState;
    }

    @NonNull
    public ViewEffect<EFFECT> viewEffect() {
        return this.viewEffect;
    }

    @MainThread
    protected void setState(@NonNull STATE state) {
        this.viewState.notify(state);
    }

    @MainThread
    protected void runEffect(@NonNull EFFECT effect) {
        this.viewEffect.notify(effect);
    }
}

