/*
 * Decompiled with CFR 0.152.
 */
package ltd.dolink.dispose.rxjava3;

import androidx.annotation.NonNull;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

class AutoDisposableCompletableObserver
extends AtomicReference<Disposable>
implements CompletableObserver,
Disposable {
    @NonNull
    private final CompletableObserver sourceObserver;

    AutoDisposableCompletableObserver(@NonNull CompletableObserver observer, @NonNull CompositeDisposable disposable) {
        Objects.requireNonNull(observer);
        Objects.requireNonNull(disposable);
        this.sourceObserver = observer;
        Disposable sourceDisposable = new Disposable(){
            private final AtomicReference<Disposable> disposable = new AtomicReference();

            public void dispose() {
                DisposableHelper.dispose(this.disposable);
                AutoDisposableCompletableObserver.this.onDispose();
            }

            public boolean isDisposed() {
                return DisposableHelper.isDisposed((Disposable)this.disposable.get());
            }
        };
        disposable.add(sourceDisposable);
    }

    private void onDispose() {
        this.dispose();
    }

    public void onSubscribe(Disposable disposable) {
        if (DisposableHelper.setOnce((AtomicReference)this, (Disposable)disposable)) {
            try {
                this.sourceObserver.onSubscribe((Disposable)this);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                disposable.dispose();
                this.onError(ex);
            }
        }
    }

    public void onError(Throwable t) {
        if (!this.isDisposed()) {
            this.lazySet(DisposableHelper.DISPOSED);
            try {
                this.sourceObserver.onError(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                RxJavaPlugins.onError((Throwable)new CompositeException(new Throwable[]{t, e}));
            }
        } else {
            RxJavaPlugins.onError((Throwable)t);
        }
    }

    public void onComplete() {
        if (!this.isDisposed()) {
            this.lazySet(DisposableHelper.DISPOSED);
            try {
                this.sourceObserver.onComplete();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                RxJavaPlugins.onError((Throwable)e);
            }
        }
    }

    public void dispose() {
        DisposableHelper.dispose((AtomicReference)this);
    }

    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)((Disposable)this.get()));
    }
}

