/*
 * Decompiled with CFR 0.152.
 */
package ltd.dolink.dispose.rxjava3;

import androidx.annotation.NonNull;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

class AutoDisposableSingleObserver<T>
extends AtomicReference<Disposable>
implements SingleObserver<T>,
Disposable {
    @NonNull
    private final SingleObserver<T> sourceObserver;

    AutoDisposableSingleObserver(@NonNull SingleObserver<T> observer, @NonNull CompositeDisposable disposable) {
        Objects.requireNonNull(observer);
        Objects.requireNonNull(disposable);
        this.sourceObserver = observer;
        Disposable sourceDisposable = new Disposable(){
            private final AtomicReference<Disposable> disposable = new AtomicReference();

            public void dispose() {
                DisposableHelper.dispose(this.disposable);
                AutoDisposableSingleObserver.this.onDispose();
            }

            public boolean isDisposed() {
                return DisposableHelper.isDisposed((Disposable)this.disposable.get());
            }
        };
        disposable.add(sourceDisposable);
    }

    private void onDispose() {
        this.dispose();
    }

    public void onSubscribe(Disposable disposable) {
        if (DisposableHelper.setOnce((AtomicReference)this, (Disposable)disposable)) {
            try {
                this.sourceObserver.onSubscribe((Disposable)this);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                disposable.dispose();
                this.onError(ex);
            }
        }
    }

    public void onSuccess(T t) {
        if (!this.isDisposed()) {
            this.lazySet(DisposableHelper.DISPOSED);
            try {
                this.sourceObserver.onSuccess(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                this.onError(e);
            }
        }
    }

    public void onError(Throwable t) {
        if (!this.isDisposed()) {
            this.lazySet(DisposableHelper.DISPOSED);
            try {
                this.sourceObserver.onError(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                RxJavaPlugins.onError((Throwable)new CompositeException(new Throwable[]{t, e}));
            }
        } else {
            RxJavaPlugins.onError((Throwable)t);
        }
    }

    public void dispose() {
        DisposableHelper.dispose((AtomicReference)this);
    }

    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)((Disposable)this.get()));
    }
}

