/*
 * Decompiled with CFR 0.152.
 */
package ltd.dolink.dispose.rxjava3;

import androidx.annotation.NonNull;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class AutoDisposableSubscriber<T>
extends AtomicReference<Subscription>
implements Subscriber<T>,
Disposable,
Subscription {
    @NonNull
    private final Subscriber<T> sourceObserver;

    AutoDisposableSubscriber(@NonNull Subscriber<T> observer, @NonNull CompositeDisposable disposable) {
        Objects.requireNonNull(observer);
        Objects.requireNonNull(disposable);
        this.sourceObserver = observer;
        Disposable sourceDisposable = new Disposable(){
            private final AtomicReference<Disposable> disposable = new AtomicReference();

            public void dispose() {
                DisposableHelper.dispose(this.disposable);
                AutoDisposableSubscriber.this.onDispose();
            }

            public boolean isDisposed() {
                return DisposableHelper.isDisposed((Disposable)this.disposable.get());
            }
        };
        disposable.add(sourceDisposable);
    }

    private void onDispose() {
        this.dispose();
    }

    public void onSubscribe(Subscription subscription) {
        if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)subscription)) {
            try {
                this.sourceObserver.onSubscribe((Subscription)this);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                subscription.cancel();
                this.onError(ex);
            }
        }
    }

    public void onNext(T t) {
        if (!this.isDisposed()) {
            try {
                this.sourceObserver.onNext(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                ((Subscription)this.get()).cancel();
                this.onError(e);
            }
        }
    }

    public void onError(Throwable t) {
        if (!this.isDisposed()) {
            this.lazySet(SubscriptionHelper.CANCELLED);
            try {
                this.sourceObserver.onError(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                RxJavaPlugins.onError((Throwable)new CompositeException(new Throwable[]{t, e}));
            }
        } else {
            RxJavaPlugins.onError((Throwable)t);
        }
    }

    public void onComplete() {
        if (!this.isDisposed()) {
            this.lazySet(SubscriptionHelper.CANCELLED);
            try {
                this.sourceObserver.onComplete();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                RxJavaPlugins.onError((Throwable)e);
            }
        }
    }

    public void dispose() {
        SubscriptionHelper.cancel((AtomicReference)this);
    }

    public boolean isDisposed() {
        return this.get() == SubscriptionHelper.CANCELLED;
    }

    public void request(long n) {
        ((Subscription)this.get()).request(n);
    }

    public void cancel() {
        this.dispose();
    }
}

