/*
 * Decompiled with CFR 0.152.
 */
package ltd.dolink.dispose.rxjava3;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.CompletableTransformer;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.MaybeTransformer;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.ObservableTransformer;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.core.SingleTransformer;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.parallel.ParallelFlowable;
import io.reactivex.rxjava3.parallel.ParallelTransformer;
import java.util.Objects;
import ltd.dolink.dispose.rxjava3.AutoDisposableCompletable;
import ltd.dolink.dispose.rxjava3.AutoDisposableFlowable;
import ltd.dolink.dispose.rxjava3.AutoDisposableMaybe;
import ltd.dolink.dispose.rxjava3.AutoDisposableObservable;
import ltd.dolink.dispose.rxjava3.AutoDisposableParallelFlowable;
import ltd.dolink.dispose.rxjava3.AutoDisposableSingle;
import org.reactivestreams.Publisher;

public class RxLifecycle<T>
implements ObservableTransformer<T, T>,
FlowableTransformer<T, T>,
MaybeTransformer<T, T>,
SingleTransformer<T, T>,
ParallelTransformer<T, T>,
CompletableTransformer {
    private final CompositeDisposable disposable = new CompositeDisposable();

    @MainThread
    public static <T> RxLifecycle<T> from(@NonNull LifecycleOwner lifecycleOwner) {
        return RxLifecycle.from(lifecycleOwner, Lifecycle.Event.ON_DESTROY);
    }

    @MainThread
    public static <T> RxLifecycle<T> from(final @NonNull LifecycleOwner lifecycleOwner, final @NonNull Lifecycle.Event event) {
        Objects.requireNonNull(lifecycleOwner);
        Objects.requireNonNull(event);
        final RxLifecycle<T> lifecycle = new RxLifecycle<T>();
        lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)new LifecycleEventObserver(){

            public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event current) {
                lifecycle.onLifecycle(current, event);
                if (current == Lifecycle.Event.ON_DESTROY) {
                    lifecycleOwner.getLifecycle().removeObserver((LifecycleObserver)this);
                }
            }
        });
        return lifecycle;
    }

    private void onLifecycle(@NonNull Lifecycle.Event current, @NonNull Lifecycle.Event event) {
        if (current.compareTo((Enum)event) >= 0) {
            this.disposable.dispose();
        }
    }

    public CompletableSource apply(Completable upstream) {
        return new AutoDisposableCompletable(upstream, this.disposable);
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        return new AutoDisposableFlowable<T>(upstream, this.disposable);
    }

    public MaybeSource<T> apply(Maybe<T> upstream) {
        return new AutoDisposableMaybe<T>(upstream, this.disposable);
    }

    public ObservableSource<T> apply(Observable<T> upstream) {
        return new AutoDisposableObservable<T>(upstream, this.disposable);
    }

    public SingleSource<T> apply(Single<T> upstream) {
        return new AutoDisposableSingle<T>(upstream, this.disposable);
    }

    public ParallelFlowable<T> apply(ParallelFlowable<T> upstream) {
        return new AutoDisposableParallelFlowable<T>(upstream, this.disposable);
    }
}

