/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.database.mybatis.generic.config;

import javax.sql.DataSource;
import ltd.fdsa.core.util.NamingUtils;
import ltd.fdsa.database.mybatis.generic.annotation.MybatisGenericMapper;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import tk.mybatis.spring.annotation.MapperScan;

@Configuration
@MapperScan(basePackages={"**.mybatis.generic.mapper.reader.**"}, annotationClass=MybatisGenericMapper.class, sqlSessionFactoryRef="readSqlSessionFactory")
public class ReaderConfig {
    private static final Logger log = LoggerFactory.getLogger(ReaderConfig.class);
    @Value(value="${mybatis.mapperLocations:classpath:mybatisMappers/**/*.xml}")
    String mapperLocation;
    @Value(value="${mybatis.config-location:classpath:mybatis-config.xml}")
    String configLocation;
    @Value(value="${project.mybatis.data.security:false}")
    boolean security;

    @Bean(name={"readSqlSessionFactory"})
    @ConditionalOnMissingBean(name={"readSqlSessionFactory"})
    public SqlSessionFactory readSqlSessionFactory(@Qualifier(value="readerDataSource") DataSource dataSource) throws Exception {
        NamingUtils.formatLog((Logger)log, (String)"ReadSqlSessionFactory start For GENERIC", (Object[])new Object[0]);
        SqlSessionFactoryBean sessionFactoryBean = new SqlSessionFactoryBean();
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        sessionFactoryBean.setDataSource(dataSource);
        sessionFactoryBean.setConfigLocation(resourcePatternResolver.getResource(this.configLocation));
        sessionFactoryBean.setMapperLocations(resourcePatternResolver.getResources(this.mapperLocation));
        sessionFactoryBean.setDefaultEnumTypeHandler(EnumOrdinalTypeHandler.class);
        SqlSessionFactory sessionFactory = sessionFactoryBean.getObject();
        if (this.security) {
            org.apache.ibatis.session.Configuration configuration = sessionFactory.getConfiguration();
        }
        return sessionFactory;
    }
}

