/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.database.mybatis.config;

import javax.sql.DataSource;
import ltd.fdsa.core.util.NamingUtils;
import ltd.fdsa.database.mybatis.handler.LongArrayTypeHandler;
import ltd.fdsa.database.mybatis.handler.StringArrayTypeHandler;
import ltd.fdsa.database.mybatis.interceptor.DecryptResultFieldInterceptor;
import ltd.fdsa.database.mybatis.interceptor.EncryptParameterInterceptor;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.TypeHandler;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Configuration
@MapperScan(basePackages={"**.mybatis.mapper.reader.**"}, annotationClass=Mapper.class, sqlSessionFactoryRef="readSqlSessionFactory")
public class ReaderConfig {
    private static final Logger log = LoggerFactory.getLogger(ReaderConfig.class);
    public static final String READ_SQL_SESSION_FACTORY = "readSqlSessionFactory";
    @Value(value="${mybatis.mapperLocations:classpath:mybatisMappers/**/*.xml}")
    String mapperLocation;
    @Value(value="${mybatis.config-location:classpath:mybatis-config.xml}")
    String configLocation;
    @Value(value="${project.mybatis.data.security:false}")
    boolean security;

    @Bean(name={"readSqlSessionFactory"})
    @ConditionalOnMissingBean(name={"readSqlSessionFactory"})
    public SqlSessionFactory readSqlSessionFactory(@Qualifier(value="readerDataSource") DataSource dataSource) throws Exception {
        NamingUtils.formatLog((Logger)log, (String)"ReadSqlSessionFactory start=", (Object[])new Object[0]);
        SqlSessionFactoryBean sessionFactoryBean = new SqlSessionFactoryBean();
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        sessionFactoryBean.setDataSource(dataSource);
        sessionFactoryBean.setConfigLocation(resourcePatternResolver.getResource(this.configLocation));
        sessionFactoryBean.setMapperLocations(resourcePatternResolver.getResources(this.mapperLocation));
        sessionFactoryBean.setTypeHandlers(new TypeHandler[]{new LongArrayTypeHandler(), new StringArrayTypeHandler()});
        SqlSessionFactory sessionFactory = sessionFactoryBean.getObject();
        if (this.security) {
            org.apache.ibatis.session.Configuration configuration = sessionFactory.getConfiguration();
            configuration.addInterceptor((Interceptor)new EncryptParameterInterceptor());
            configuration.addInterceptor((Interceptor)new DecryptResultFieldInterceptor());
        }
        return sessionFactory;
    }
}

