/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.database.mybatis.handler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.apache.ibatis.type.TypeHandler;

@MappedTypes(value={Long[].class})
@MappedJdbcTypes(value={JdbcType.VARCHAR})
public class LongArrayTypeHandler
implements TypeHandler<Long[]> {
    public void setParameter(PreparedStatement ps, int i, Long[] parameter, JdbcType jdbcType) throws SQLException {
        if (parameter == null) {
            ps.setNull(i, 12);
        } else {
            StringBuffer result = new StringBuffer();
            for (Long value : parameter) {
                result.append(value).append(",");
            }
            result.deleteCharAt(result.length() - 1);
            ps.setString(i, result.toString());
        }
    }

    public Long[] getResult(ResultSet rs, String columnName) throws SQLException {
        return this.getLongArray(rs.getString(columnName));
    }

    public Long[] getResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.getLongArray(rs.getString(columnIndex));
    }

    public Long[] getResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.getLongArray(cs.getString(columnIndex));
    }

    private Long[] getLongArray(String columnValue) {
        if (columnValue == null) {
            return null;
        }
        String[] strs = columnValue.split(",");
        ArrayList<Long> list = new ArrayList<Long>();
        if (strs.length > 0) {
            for (String string : strs) {
                list.add(Long.valueOf(string));
            }
        }
        return list.toArray(new Long[0]);
    }
}

