/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.database.mybatis.interceptor;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Statement;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import ltd.fdsa.database.mybatis.interceptor.ClassFieldsUtil;
import ltd.fdsa.database.mybatis.interceptor.DataDigest;
import ltd.fdsa.database.mybatis.interceptor.DataSafe;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class DecryptResultFieldInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(DecryptResultFieldInterceptor.class);

    public Object intercept(Invocation invocation) {
        Object returnValue;
        block6: {
            returnValue = null;
            try {
                returnValue = invocation.proceed();
                if (returnValue == null) break block6;
                try {
                    if (returnValue instanceof ArrayList) {
                        ArrayList list = (ArrayList)returnValue;
                        long startTime = System.currentTimeMillis();
                        for (Object obj : list) {
                            this.handlerFields(obj);
                        }
                        log.debug("\u81ea\u52a8\u89e3\u5bc6\u8017\u65f6\uff1a{}{}", (Object)(System.currentTimeMillis() - startTime), (Object)"ms");
                    }
                }
                catch (Exception e) {
                    log.error("\u81ea\u52a8\u89e3\u5bc6\u5f02\u5e38", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error("\u89e3\u5bc6\u5b57\u6bb5\u503c\u63d2\u4ef6\u5f02\u5e38", (Throwable)e);
            }
        }
        return returnValue;
    }

    private void handlerFields(Object obj) throws Exception {
        List<Field> fields = ClassFieldsUtil.getAllFields(obj);
        for (Field field : fields) {
            this.handlerChildFields(obj, field);
        }
    }

    private void handlerChildFields(Object obj, Field field) throws Exception {
        field.setAccessible(true);
        if (Collection.class.isAssignableFrom(field.getType())) {
            Type type = field.getGenericType();
            if (type instanceof ParameterizedType) {
                Class clazz = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
                Collection<Class> childCollection = this.setElementValue(obj, field, clazz, field.getType());
                field.set(obj, childCollection);
            }
        } else {
            this.decryptField(obj, field);
        }
    }

    private <T> Collection<T> setElementValue(Object obj, Field field, T elementType, Class collectionType) throws Exception {
        AbstractCollection collection = collectionType == List.class ? new ArrayList() : new HashSet();
        Collection originalElements = (Collection)field.get(obj);
        if (CollectionUtils.isEmpty((Collection)originalElements)) {
            return null;
        }
        for (Object innerObject : originalElements) {
            List<Field> innerFields = ClassFieldsUtil.getAllFields(innerObject);
            for (Field innerField : innerFields) {
                innerField.setAccessible(true);
                this.handlerChildFields(innerObject, innerField);
            }
            collection.add(innerObject);
        }
        return collection;
    }

    private void decryptField(Object obj, Field field) throws Exception {
        if (field.isAnnotationPresent(DataSafe.class)) {
            if (!(field.getType().getName() instanceof String)) {
                throw new Exception("\u89e3\u5bc6\u5b57\u6bb5\uff1a" + obj.getClass().getName() + " : " + field.getName() + " \u5fc5\u987b\u662fString\u7c7b\u578b\u3002");
            }
            String originalValue = (String)field.get(obj);
            if (originalValue != null) {
                String result = DataDigest.decrypt(originalValue);
                field.set(obj, result);
            }
        }
    }

    public Object plugin(Object target) {
        if (target instanceof ResultSetHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

