/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.database.mybatis.interceptor;

import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.Properties;
import ltd.fdsa.database.mybatis.interceptor.ClassFieldsUtil;
import ltd.fdsa.database.mybatis.interceptor.DataDigest;
import ltd.fdsa.database.mybatis.interceptor.DataSafe;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=ParameterHandler.class, method="setParameters", args={PreparedStatement.class})})
public class EncryptParameterInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(EncryptParameterInterceptor.class);

    public Object intercept(Invocation invocation) {
        Object returnObject = null;
        try {
            ParameterHandler parameterHandler = (ParameterHandler)invocation.getTarget();
            Object obj = parameterHandler.getParameterObject();
            if (obj != null) {
                List<Field> fields = ClassFieldsUtil.getAllFields(obj);
                for (Field field : fields) {
                    field.setAccessible(true);
                    if (!field.isAnnotationPresent(DataSafe.class)) continue;
                    if (field.getType().getName() instanceof String) {
                        String originalValue = (String)field.get(obj);
                        if (originalValue == null) continue;
                        String result = DataDigest.encrypt(originalValue);
                        field.set(obj, result);
                        log.debug("\u53c2\u6570\u5b57\u6bb5\u52a0\u5bc6\uff1a{}#{}", (Object)obj.getClass().getName(), (Object)field.getName());
                        continue;
                    }
                    throw new Exception("\u52a0\u5bc6\u5b57\u6bb5\uff1a" + obj.getClass().getName() + " : " + field.getName() + " \u5fc5\u987b\u662fString\u7c7b\u578b\u3002");
                }
            }
            returnObject = invocation.proceed();
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6\u53c2\u6570\u503c\u63d2\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        return returnObject;
    }

    public Object plugin(Object target) {
        if (target instanceof ParameterHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

