/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.simba.redis;

import com.google.common.base.Strings;

public class Message {
    public static final String EVENT_RELEASED = "released";
    public static final String EVENT_ACQUIRED = "acquired";
    public static final String DELIMITER = "@@";
    private final String event;
    private final String ownerId;

    public Message(String event, String ownerId) {
        this.event = event;
        this.ownerId = ownerId;
    }

    public String getEvent() {
        return this.event;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public static Message of(String message) {
        String[] msgs = message.split(DELIMITER);
        if (msgs.length != 2) {
            throw new IllegalStateException(Strings.lenientFormat((String)"Incorrect message format:[%s]", (Object[])new Object[]{message}));
        }
        return new Message(msgs[0], msgs[1]);
    }
}

