/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.simba.redis;

import io.lettuce.core.api.reactive.RedisScriptingReactiveCommands;
import io.lettuce.core.pubsub.api.reactive.RedisPubSubReactiveCommands;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import me.ahoo.simba.core.MutexContendService;
import me.ahoo.simba.core.MutexContendServiceFactory;
import me.ahoo.simba.core.MutexContender;
import me.ahoo.simba.redis.RedisMutexContendService;

public class RedisMutexContendServiceFactory
implements MutexContendServiceFactory {
    private final Executor handleExecutor;
    private final Duration ttl;
    private final RedisScriptingReactiveCommands<String, String> redisCommands;
    private final RedisPubSubReactiveCommands<String, String> redisPubSubCommands;

    public RedisMutexContendServiceFactory(Duration ttl, RedisScriptingReactiveCommands<String, String> redisCommands, RedisPubSubReactiveCommands<String, String> redisPubSubCommands) {
        this(ForkJoinPool.commonPool(), ttl, redisCommands, redisPubSubCommands);
    }

    public RedisMutexContendServiceFactory(Executor handleExecutor, Duration ttl, RedisScriptingReactiveCommands<String, String> redisCommands, RedisPubSubReactiveCommands<String, String> redisPubSubCommands) {
        this.handleExecutor = handleExecutor;
        this.ttl = ttl;
        this.redisCommands = redisCommands;
        this.redisPubSubCommands = redisPubSubCommands;
    }

    public MutexContendService createMutexContendService(MutexContender mutexContender) {
        return new RedisMutexContendService(mutexContender, this.handleExecutor, this.ttl, this.redisCommands, this.redisPubSubCommands);
    }
}

