redis.replicate_commands();

local mutex = KEYS[1];
local ownerId = ARGV[1];
local ttl = ARGV[2];
local mutexKey = 'simba:' .. mutex;
-- 1. 尝试获取锁资源，如果获取成功直接返回
local succeed = redis.call("set", mutexKey, ownerId, 'nx', 'px', ttl)

if succeed then
    local message = 'acquired@@' .. ownerId;
    redis.call("publish", mutexKey, message)
    return succeed;
end

-- 2. 将自己（Waiter）加入互斥体等待队列
local waiterQueueKey = mutexKey .. ":waiter";

local nowTime = redis.call('time')[1];
redis.call("zadd", waiterQueueKey, 'nx', nowTime, ownerId)

return succeed;
