local mutex = KEYS[1];
local ownerId = ARGV[1];
local mutexKey = 'simba:' .. mutex;
local waiterQueueKey = mutexKey .. ":waiter";
-- 1. 获取当前锁的 ownerId 锁是否与自己持久的相同（判断当前锁是否是自己锁定的），如果不相同则直接退出，返回释放失败

if redis.call("get", mutexKey) ~= ownerId then
    redis.call("zrem", waiterQueueKey, ownerId)
    return 0;
end

-- 2. 删除当前锁定的资源

local succeed = redis.call("del", mutexKey)

if not succeed then
    return succeed;
end

-- 3.从等待队列里边获取到第一个 Waiter,并发布锁释放通知

local nextWaiter = redis.call("zrevrange", waiterQueueKey, -1, -1);

if #nextWaiter == 0 then
    return succeed;
end

nextWaiter = nextWaiter[1];
redis.call("zrem", waiterQueueKey, nextWaiter)

local channel = mutexKey .. ":" .. nextWaiter;
local message = 'released@@' .. ownerId;
redis.call("publish", channel, message)

return succeed;
